<?php
require_once 'config.php';
require_once 'functions.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (login($username, $password, $conn)) {
        header('Location: index.php');
        exit();
    } else {
        $error = 'Invalid username or password';
    }
}

if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo APP_NAME; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            font-family: 'Manrope', sans-serif; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 420px;
            padding: 48px;
        }
        .logo-section {
            text-align: center;
            margin-bottom: 32px;
        }
        .logo {
            height: 48px;
            margin-bottom: 16px;
        }
        .app-name {
            font-size: 28px;
            font-weight: 700;
            color: #0066b2;
            margin-bottom: 8px;
        }
        .app-tagline {
            font-size: 14px;
            color: #64748b;
        }
        .form-group {
            margin-bottom: 24px;
        }
        label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #334155;
            margin-bottom: 8px;
        }
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 15px;
            font-family: 'Manrope', sans-serif;
            transition: all 0.3s;
        }
        input[type="text"]:focus,
        input[type="password"]:focus {
            outline: none;
            border-color: #0066b2;
            box-shadow: 0 0 0 3px rgba(0, 102, 178, 0.1);
        }
        .error {
            background: #fee2e2;
            color: #991b1b;
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            border-left: 4px solid #dc2626;
        }
        .btn-login {
            width: 100%;
            padding: 14px;
            background: #0066b2;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            font-family: 'Manrope', sans-serif;
        }
        .btn-login:hover {
            background: #005a9e;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 102, 178, 0.3);
        }
        .login-footer {
            margin-top: 24px;
            text-align: center;
            font-size: 13px;
            color: #64748b;
        }
        .demo-credentials {
            margin-top: 24px;
            padding: 16px;
            background: #f8fafc;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
        }
        .demo-credentials h4 {
            font-size: 13px;
            font-weight: 600;
            color: #64748b;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .demo-credentials p {
            font-size: 14px;
            color: #334155;
            margin: 4px 0;
        }
        .demo-credentials code {
            background: white;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
            color: #0066b2;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo-section">
            <img src="<?php echo LOGO_URL; ?>" alt="Logo" class="logo">
            <h1 class="app-name"><?php echo APP_NAME; ?></h1>
            <p class="app-tagline">Engineer Performance & Time Analysis</p>
        </div>
        
        <?php if ($error): ?>
        <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required autofocus>
            </div>
            
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <button type="submit" class="btn-login">Sign In</button>
        </form>
        
        <div class="demo-credentials">
            <h4>Demo Credentials</h4>
            <p>Username: <code>admin</code></p>
            <p>Password: <code>admin123</code></p>
        </div>
        
        <div class="login-footer">
            &copy; 2024 <?php echo APP_NAME; ?>. All rights reserved.
        </div>
    </div>
</body>
</html>
