<?php
require_once 'config.php';

function requireLogin() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit();
    }
}

function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

function login($username, $password, $conn) {
    $stmt = $conn->prepare("SELECT id, password, full_name, role FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $username;
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['role'] = $user['role'];
            return true;
        }
    }
    return false;
}

function logout() {
    session_destroy();
    header('Location: login.php');
    exit();
}

// Check if CSV file exists
function checkDataFile() {
    if (!file_exists(DATA_FILE_PATH)) {
        return false;
    }
    return true;
}

// Get file last modified date
function getDataFileDate() {
    if (file_exists(DATA_FILE_PATH)) {
        return date("F d, Y H:i:s", filemtime(DATA_FILE_PATH));
    }
    return "Unknown";
}

// Read CSV file and return data array
function readCSVData() {
    if (!file_exists(DATA_FILE_PATH)) {
        return [];
    }
    
    $data = [];
    $handle = fopen(DATA_FILE_PATH, 'r');
    
    // Skip header row
    $headers = fgetcsv($handle);
    
    // Read all data rows
    while (($row = fgetcsv($handle)) !== false) {
        $data[] = $row;
    }
    
    fclose($handle);
    return $data;
}

// Format number with 2 decimal places
function formatNumber($number, $decimals = 2) {
    return number_format((float)$number, $decimals, '.', ',');
}

// Format percentage
function formatPercent($number, $decimals = 1) {
    return number_format((float)$number * 100, $decimals, '.', ',') . '%';
}

// Convert hours to readable format
function formatHours($hours) {
    if ($hours < 0.1) return '0h';
    
    $h = floor($hours);
    $m = round(($hours - $h) * 60);
    
    if ($h == 0) return $m . 'm';
    if ($m == 0) return $h . 'h';
    return $h . 'h ' . $m . 'm';
}
?>
