# TimeTrack Analytics

A comprehensive PHP application for analyzing engineer time reports with performance metrics, contract analysis, travel efficiency, and documentation compliance tracking.

## 📋 Features

### Analysis Modules

1. **Engineer Performance & Overtime**
   - Total jobs handled per engineer
   - Allocated vs actual hours comparison
   - Overtime hours calculation
   - Jobs exceeding allocated time tracking

2. **Contract & Customer Analysis**
   - Contract-level job summaries
   - Hour allocation vs usage tracking
   - Overtime analysis per contract
   - Exceeded rate calculations

3. **Travel vs Work Efficiency**
   - Travel time vs work time breakdown
   - Travel share percentage analysis
   - Route optimization insights
   - Top engineers by travel percentage

4. **Documentation Compliance**
   - Documentation attachment tracking
   - Compliance rate per engineer
   - Undocumented job identification
   - Improvement area highlighting

### Key Features
- ✅ Clean, modern UI with responsive design
- ✅ Interactive Chart.js visualizations
- ✅ Excel file processing with PhpSpreadsheet
- ✅ User authentication system
- ✅ Help tooltips with analysis methodology
- ✅ Exportable data tables
- ✅ Real-time calculations

## 🚀 Installation

### Prerequisites
- PHP 7.4 or higher
- MySQL/MariaDB database
- Apache/Nginx web server
- Composer (PHP dependency manager)

### Step 1: Install Dependencies

```bash
# Navigate to project directory
cd time_report_app

# Install Composer (if not already installed)
curl -sS https://getcomposer.org/installer | php

# Install PHP dependencies
php composer.phar install
# OR if composer is installed globally:
composer install
```

### Step 2: Configure Database

1. Create a MySQL database:
```sql
CREATE DATABASE time_report_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

2. Update database credentials in `config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('DB_NAME', 'time_report_db');
```

3. The application will automatically create required tables on first run.

### Step 3: Upload Excel File

Place your `Time_Report.xlsx` file in the `data/` directory:
```bash
cp /path/to/Time_Report.xlsx data/
```

### Step 4: Configure Web Server

#### Apache (.htaccess)
```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php [QSA,L]
</IfModule>
```

#### Nginx
```nginx
server {
    listen 80;
    server_name your-domain.com;
    root /path/to/time_report_app;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
    }
}
```

### Step 5: Set Permissions

```bash
# Make data directory writable
chmod 755 data/
chmod 644 data/Time_Report.xlsx

# Set appropriate permissions for the web server
chown -R www-data:www-data time_report_app/
```

## 🔐 Default Login Credentials

- **Username:** `admin`
- **Password:** `admin123`

⚠️ **Important:** Change the default password after first login!

## 📊 Excel File Format

The application expects an Excel file with the following columns:

| Column | Description |
|--------|-------------|
| COMPANY | Company identifier |
| CONTRACT | Contract code |
| CONTRACT_NAME | Full contract name |
| WO_NO | Work order number (unique job ID) |
| ENG_NAME | Engineer name |
| ALLOCATED_HOURS | Hours allocated for the job |
| WORK_TIME | Actual work hours logged |
| TRAVELLING_TIME | Travel time in hours |
| DOC_ATTACHED | Documentation status (Yes/No) |

## 🎨 Customization

### Changing App Name and Logo

Edit `config.php`:
```php
define('APP_NAME', 'Your Company Name');
define('LOGO_URL', 'path/to/your/logo.png');
```

### Adding New Analysis

1. Create a new PHP file in `analysis/` directory
2. Copy the structure from existing analysis files
3. Add menu item in the sidebar
4. Implement your custom analysis logic

## 📈 Analysis Methodology

### Engineer Performance
- **Jobs:** Unique work orders (WO_NO) per engineer
- **Overtime:** `max(0, Actual Hours - Allocated Hours)`
- **Overtime Ratio:** `Overtime / Total Allocated Hours`

### Contract Analysis
- **Exceeded Rate:** `Exceeded Jobs / Total Jobs`
- **Overtime Hours:** `Total Worked - Total Allocated`

### Travel Efficiency
- **Travel Share:** `Travel Hours / (Work Hours + Travel Hours)`
- Higher percentages indicate optimization opportunities

### Documentation
- **Doc Rate:** `Documented Jobs / Total Jobs`
- Based on DOC_ATTACHED field (Yes/True/1)

## 🛠️ Troubleshooting

### Excel File Not Loading
- Check file path in `config.php`
- Verify file permissions (644)
- Ensure PhpSpreadsheet is installed

### Database Connection Errors
- Verify MySQL service is running
- Check database credentials
- Ensure database exists

### Chart Not Displaying
- Check browser console for JavaScript errors
- Verify Chart.js CDN is accessible
- Ensure data is being passed correctly

### Blank Pages
- Enable PHP error reporting in development:
```php
ini_set('display_errors', 1);
error_reporting(E_ALL);
```

## 📁 Directory Structure

```
time_report_app/
├── analysis/                    # Analysis modules
│   ├── engineer_performance.php
│   ├── contract_view.php
│   ├── travel_efficiency.php
│   └── documentation.php
├── data/                        # Excel file storage
│   └── Time_Report.xlsx
├── vendor/                      # Composer dependencies
├── config.php                   # Configuration file
├── functions.php                # Helper functions
├── index.php                    # Dashboard
├── login.php                    # Authentication
├── logout.php                   # Logout handler
├── composer.json                # Dependency definitions
└── README.md                    # This file
```

## 🔒 Security Notes

- Change default admin password immediately
- Use HTTPS in production
- Keep PhpSpreadsheet updated
- Sanitize user inputs
- Implement proper session management
- Regular database backups

## 📝 License

This project is provided as-is for internal use.

## 🤝 Support

For issues or questions:
1. Check the troubleshooting section
2. Review PHP error logs
3. Verify Excel file format
4. Ensure all dependencies are installed

## 🔄 Updating Excel Data

To update with new time report data:
1. Replace `data/Time_Report.xlsx` with new file
2. Keep the same column structure
3. Refresh the dashboard
4. All analysis will update automatically

## 🎯 Best Practices

1. **Regular Updates:** Update Excel file monthly
2. **Data Quality:** Ensure DOC_ATTACHED field is properly filled
3. **Performance:** Archive old data periodically
4. **Backups:** Regular database and Excel file backups
5. **Monitoring:** Review all four analysis reports weekly

---

Built with ❤️ for efficient time tracking and analysis
